<?php

//Start session for captcha or security code

session_start();
?>
<!--Start the head tag as well as display the page title-->
<html>
<body>
<head>
<title>PHP XML sitemap code generator</title>
</head>
<?php

//Check if the form is submitted

if (!$_POST['submit'])
{

//If the web form is not submitted, display the form

?>

<!--This is the actual web form-->

<br />

<!--This form will submit the data to itself using PHP SELF-->

<form action="<?php echo $SERVER['PHP_SELF']; ?>"
method="post">
<font face="Verdana" size="2">

<!--Below is the form content, instructions on how to use-->

This tool will generate the source code of an XML sitemap which you can copy(control-A then control-C) and paste the results to a notepad blank file and save as "sitemap.xml"<br />
This is using <a href="http://www.google.com/support/webmasters/bin/answer.py?answer=34657">Google XML sitemap standard</a> for making custom XML sitemaps.<br />
Enter ALL canonical URLs below(STRICTLY one URL per line).<a rel="nofollow" href="/xmlsitemapgenerator/xmlsitemap.jpg">See sample here</a><br />
<b>It is highly recommended to sort the URLs from the most important to least important WHEN YOU ENTER IT in the text area(most important first- e.g your "homepage")</b><br />
The most important URL will be automatically assigned with priority "1.0" and least priority used is "0.5".<b>Make sure your homepage are entered in the text area first.</b><br />
Upload your sitemap.xml to the root directory of your domain/sub-domain. For example: <i>http://www.thisisyourdomain.com/sitemap.xml</i> or if you are using a sub-domain:<i>http://yoursubdomain.thisisyourdomain.com/sitemap.xml</i>.<br />
Once it is live in the server root directory, you can safely submit it to your website Google webmaster tools account.<br />
<br />
<i>Developer: Codex-m at <a href="http://www.php-developer.org">PHP Developer Blog</a></a></i>
<br /><br />
</font><br />

<!--The Text area HTML code which will accepts user inputs in terms of URL-->

<!--It also includes the captcha or the security code-->

<textarea name="url" rows="18" cols="120"></textarea>
<br /><br />
<img src="/xmlsitemapgenerator/antibot.php" />
<br />
Type the anti-bot code above:
<br /> <br />
<input type="text" name="captcha" size="10">
<br /> <br />
<input type="submit" name="submit" value="Generate Sitemap XML code">
</form>
<a href="/xmlsitemapgenerator/xmlsitemapgenerator.php">Click here to reset or clear this form</a>

<?php
}
else
{

//The web form has been submitted, grab the data from POST as well as remove the white space using trim command

$url =trim($_POST['url']);

//Check if the form submitted contains any data.
//Also check if the security code is correct.
//More information about captcha design here http://www.devshed.com/c/a/PHP/Designing-a-Captcha-System-with-PHP-and-MySQL/

if ((empty($url)) || (!(trim($_POST['captcha'])==$_SESSION['answer'])))
{

//Feedback to the user that the form does not contain any data

die ('ERROR: Enter figures or correct captcha. <a href="/descriptivestats.php">Click here to proceed with the analysis</a>');
}
else
{

//The data from the $url comes from an array (POST),
//You need to explode the data from the array using PHP explode function
//And then assigned the data to a $data variable
//This will do the job of actually parsing the URL from the web form

$data = explode("\n", $url);

//Display to the web browser the heading sections of the XML syntax using Google XML sitemap standard

echo '<font face="Courier New" size="2">';
echo '<font color="#C0547F"><i>&lt;&#63;xml version&#61;&#34;1.0&#34; encoding&#61;&#34;UTF&#45;8&#34;&#63;&#62;</i></font>';
echo '<br />';
echo '<font color="#7C137F"><b>&lt;urlset</b></font> <b>xmlns</b>&#61;<font color="blue">&#34;http://www.sitemaps.org/schemas/sitemap/0.9&#34;</font>&gt;';
echo '<br /><br />';

//The code below computes the priority of the URLs in sitemap.
//The most important URL (the one entered first by the user in the web form has a priority of 1.)
//The minimum or lowest assigned priority is 0.5 regardless of how many URLs are being processed.
//To compute the decrement value or how much is the priority differences between the highest priority of 1 to the lowest assigned priority of 0.5 are to use the formula:
// (0.5)/ ((Number of URLs)-1)
//In PHP, it needs to use the sizeof function to count the number of URLs in the data variable.

$difference = (-0.5)/((sizeof($data))-1);

//The following below is a WHILE Loop which will do the actual tasks of generating the XML syntax for all the URLs

$priority=1.0;
while (($priority>=0.4) && (list($key,$value) = each($data))) {
$roundpriority=round($priority,2);
echo "<font color='#7C137F'><b>&lt;url</b></font>&gt;";
echo "<br />";
echo "&nbsp;&nbsp;&lt;<font color='#7C137F'><b>loc</b></font>&gt;$value&lt;&#47;<font color='#7C137F'><b>loc</b></font>&gt;";
echo "<br />";
echo "&nbsp;&nbsp;&lt;<font color='#7C137F'><b>priority</b></font>&gt;$roundpriority&lt;&#47;<font color='#7C137F'><b>priority</b></font>&gt;";
echo "<br />";
echo "&lt;&#47;<font color='#7C137F'><b>url</b></font>&gt;";
echo "<br /><br />";

//after each loop, the priority is decreased by a difference value computed earlier, the $difference variable is a negative number.

$priority=$priority+$difference;
}
echo "&lt;&#47;<font color='#7C137F'><b>urlset</b></font>&gt;";
}
}
?>

<!--Clears out the session variable-->

<?php
$_SESSION = array ();
session_destroy ();
?>
</body>
</html>
