<?php
//Gzip compression
//This is optional but can make website loading fast
ob_start("ob_gzhandler");
?>
<!--//---------------------------------------------------------------------------------------------------------------------+ |
//  Count Unique Back links using Yahoo API web form written by: Codex-m                                                     |
//  This tool is capable of detecting backlinks in Unique Class C IP address and also the relevance of the backlinking pages |
//	http://www.php-developer.org                                                                                             |
//  License: Open source, Freel free to link to http://www.php-developer.org to show support and help me promote this tool   |
//  Documentation: http://www.devshed.com/cp/bio/Codex%98M/ and search all Yahoo API related tutorials                       |
//--------------------------------------------------------------------------------------------------------------------------->
<html>
<head>
<title>Check your Link Popularity | Free Backlink Check Count Tool</title>
<h3>This tool will check the number of back links/inbound links coming from unique domains.</h3>
<br />
This tool is capable of distinguishing backlinks in unique Class C IP address as well as evaluating the relevance of the inbound link page.
<br />
This is a very useful tool to assess both the quantity and quality of your backlinks, important in search engine optimization.
<br />
Please fill in required data and click "Submit" button. Please be patient, this can take up to 2 minutes maximum to generate the report.<br />
<br />
<form NAME="linkpopularity" ACTION="<? echo $PHP_SELF; ?>" method="POST">
Enter root domain URL ( for example: <a rel="nofollow" href="http://www.php-developer.org"><b>http://www.php-developer.org</b></a>). URL <b>should</b> start <i>http://</i> and <b>DO NOT include trailing slash at the end.</b><br />
<br />
<input style="background-color: #FFFFC0" type="text" name="domainurl" id="domainurl" size="50">
<br /><br />
Select whether to get unique backlinks to the entire domain or only to the homepage URL<br />
<input type="radio" name="options1" id="options1" value="1" > Entire Site
<br />
<input type="radio" name="options2" id="options2" value="2" > Only to the homepage URL
<br />
<INPUT TYPE="HIDDEN" NAME="ref" VALUE="linkpopularity">
<br /><br />
Type the captcha below:
<br /> <br />
<?php
require_once('recaptchalib.php');
$publickey = "RECAPTCHA PUBLIC KEY";
echo recaptcha_get_html($publickey);
?>
<input type="submit" value="Submit">
</form>
This tool is developed by Codex-m at <a href="http://www.php-developer.org/">www.php-developer.org</a>.<br /><br />
<!-- Input form end -->
<?php
//First, check if the web form has been submitted by checking the value of $_POST[ref]
if($_POST[ref] == "linkpopularity") {
//If the form has been submitted, check if the recaptcha entered by the client is correct.
require_once('recaptchalib.php');
$errors=array();
$privatekey = "RECAPTCHA PRIVATE KEY";
$resp = recaptcha_check_answer ($privatekey,
                                $_SERVER["REMOTE_ADDR"],
                                $_POST["recaptcha_challenge_field"],
                                $_POST["recaptcha_response_field"]);

if (!$resp->is_valid) {
//Display error back to the client is the recaptcha entered is incorrect.
  die('<font color="red">ERROR: The recaptcha code was not entered correctly or expired. If you think it expired or correctly entered; click Recaptcha refresh button to get a new challenge and press submit again.</font>');
}
///////////////////////////////////////////////////////////////////
//extract form inputs and remove spaces//
///////////////////////////////////////////////////////////////////
$domainurl =trim($_POST['domainurl']);
$options1 =trim($_POST['options1']);
$options2 =trim($_POST['options2']);
//////////////////////////////////////////
//Validate userinput domain URL///////////
/////////////////////////////////////////
if (empty($domainurl)) {
//name field is blank
echo 'ERROR: The homepage URL field is empty.';
die ();
}
else {
//it is not empty so validate the user input
$httpprotocol= substr($domainurl, 0, 7);
$httpprotocolwrong=substr($domainurl, 0, 8);
$httpsprotocol =substr($domainurl, 0, 8);
$httpsprotocolwrong= substr($domainurl, 0, 9);
$trailingslash = substr($domainurl, -1);
$firstdot= strpos($domainurl, '.');
$offset=$firstdot + 1;
$seconddot= strpos($domainurl,'.',$offset);
if (!(($httpprotocol=='http://') || ($httpsprotocol=='https://'))) {
echo 'ERROR: Root domain URL protocol should either only be http:// or https://';
die ();
}
if (($httpprotocolwrong=='http:///') || ($httpsprotocolwrong=='https:///')) {
echo 'ERROR: Root domain URL protocol should either only be http:// or https://';
die ();
}
if ($trailingslash=='/') {
echo 'ERROR: Do not include trailing slash "/" at the end of the URL';
die ();
}
if (($firstdot=='') && ($seconddot=='')) {
echo 'ERROR: Malformed domain root URL';
die ();
}
}
/////////////////////
//Validate options///
/////////////////////
if ($options1==1) {
$options=1;
}
elseif ($options2==2) {
$options='';
}
else {
echo 'ERROR: The options field is empty.';
die ();
}
//Step 1. Report possible errors for debugging
error_reporting(E_ALL);
//Step 2. Declare the request variable
$request =  'http://search.yahooapis.com/SiteExplorerService/V1/inlinkData?appid=YOURYAHOOAPIIDHERE--&query='.$domainurl.'&results=100&output=php&omit_inlinks=domain&entire_site='.$options;

//Step 3. Read the responses from Yahoo inbound links API and put into a string.
$response = file_get_contents($request);

//Step 4
if ($response === false) {
	die('The request fails.');
}
//Step 5. Convert to unserialized
//create array to store unique domains
$unserialized = unserialize($response);
$display= $unserialized['ResultSet'];
$display1=$display['Result'];
$totalbacklinksnotunique=$display['totalResultsAvailable'];
//define the domain array
$domainarray = array();
//define the title array
$titlearray = array();
$x=0;
$count= sizeof($display1);
while ($x < $count) {
//grab the URL from the array and store to $myurl variable	
$myurl= $display1[$x]['Url'];
//grab the title tag of the URL and store to $mytitletag variable
$mytitletag = $display1[$x]['Title'];
//determine the backlink protocol
$httpprotocolcheck =substr($myurl, 0, 7);
$httpsprotocolcheck =substr($myurl, 0, 8);
if ($httpprotocolcheck=="http://") {
//http version
$backlinkprotocol= "http://";
}
if ($httpsprotocolcheck=="https://") {
//https version
$backlinkprotocol= "https://";
}
//assign offset for each protocol
if ($backlinkprotocol=="http://") {
$offsetcount= 7;
}
if ($backlinkprotocol=="https://") {
$offsetcount= 8;
}
//determine 1st occurrence of trailing slash after the protocol
$positiontrailingslash = strpos($myurl, '/', $offsetcount);
$actualposition = $positiontrailingslash - $offsetcount;
//extract domain portion for test of non-www version
$domainportion = substr($myurl, $offsetcount, $actualposition);
//count the number of dots, if only one dot found it is non-www version
$dotcount= substr_count($domainportion, '.');
if ($dotcount==1) {
$domain = $domainportion;
}
if (($dotcount==2) || ($dotcount==3)) {
//this is NOT a non-www version
//find position of 1st dot
$firstdotposition = strpos($myurl, '.');
$firstdotrealoffset= $firstdotposition +1;
//find position of 2nd dot
$seconddotposition = strpos($myurl, '.', $firstdotrealoffset);
$differenceofdots= $seconddotposition - $firstdotposition -1;
 if ($differenceofdots=="2") {
 $domain = $domainportion;
 }
 else {
 $firstdotoffset = $firstdotposition + 1;
 $trailingoffset = $positiontrailingslash - $firstdotposition -1;
 $domain = substr($myurl,$firstdotoffset, $trailingoffset);
 }
}
if ($dotcount==3) {
$firstdotoffset = $firstdotposition + 1;
$trailingoffset = $positiontrailingslash - $firstdotposition -1;
$domain = substr($myurl,$firstdotoffset, $trailingoffset);
}
//assign domain to domain array
$domainarray[]=$domain;
//assign title tag to title array
$titlearray[] = $mytitletag;
$x++;
}
//display the unique domains stored in the array
$uniquedomains=array_unique($domainarray);
//filter the unique title tags and store in the array
$uniquetitletags = array_unique($titlearray);
echo '--------------------------------------------------------------------------';
echo '<br />';
echo '|THIS IS THE LINK POPULARITY REPORT FOR '.$domainurl ;
echo '<br />';
echo '--------------------------------------------------------------------------';
echo '<br />';
////////////////////////////////////////////////
//Estimate total backlinks from unique domains//
////////////////////////////////////////////////
$uniqueinsample = sizeof($uniquedomains);
$uniquebacklinkstotal= ($uniqueinsample/$count)*($totalbacklinksnotunique);
if ($options==1) {
$conditions='ENTIRE SITE';
}
if ($options=='') {
$conditions='THAT SPECIFIC URL ONLY';
}
echo "<b>ESTIMATED TOTAL BACKLINKS FROM UNIQUE DOMAINS POINTING TO $conditions:&nbsp;".round($uniquebacklinkstotal).'</b>';
echo '<br /><br />';
echo "These are the unique domains of the total $totalbacklinksnotunique backlinks pointing to $conditions.";
echo '<br />';
echo "In a sample gathered, you have $uniqueinsample backlinks from unique domains OUT of $count SAMPLES GATHERED";
echo '<br />';
echo 'Below are the sample unique backlinking domains:(100 domains maximum)';
echo '<br /><br />';
//Define unique IP address array
$iparray = array();
while (list($key, $value) = each($uniquedomains)) {
//Get IP address of its domains
$ipaddress=gethostbyname($value);
$findme   = '.';
$lastdot= strlen(strrchr($ipaddress,$findme));
$filterclassc= (-1) * $lastdot;
$classcip = substr($ipaddress, 0, $filterclassc);
$classcip = trim($classcip);
$iparray[]=$classcip;
echo $value;
echo '<br />';
}
$arrayipunique=array_unique($iparray);
$uniqueip = sizeof($arrayipunique);
echo '<br />';
echo "In those $uniqueinsample unique domains, there are $uniqueip domains in unique Class C IP.<br />";
$uniquebacklinksuniqueclassc= ($uniqueip/$count)*($totalbacklinksnotunique);
echo "<b>ESTIMATED TOTAL BACKLINKS FROM UNIQUE DOMAINS IN UNIQUE CLASS IP POINTING TO $conditions:&nbsp;".round($uniquebacklinksuniqueclassc).'</b>'; 
echo '<br />';
echo '<br />';
reset($uniquedomains);
echo '--------------------------------------------------------------------------';
echo '<br />';
echo '|THIS IS THE LINK RELEVANCE REPORT FOR '.$domainurl;
echo '<br />';
echo '-------------------------------------------------------------------------';
echo '<br />';
echo '<br />';
echo 'The relevance of your backlinks are computed based on the title tag of your backlinking pages. These title tag are important because it tells us what the backlink page is all about. The keywords from the title tag are then extracted and analyzed.';
echo '<br />';
echo 'If these keyword lists that is sorted by percentages MATCHES with your domain or website topic or niche, then congratulations; your backlinks are relevant to your website.<br />';
echo '<br />';
//###combine all words in an unique title tags array as one sentence for analysis
$sentenceforanalysis= implode(" ",$uniquetitletags);
//###compute the keyword occurrence percentage
//### str_word_count($str,1) - returns an array containing all the words found inside the string
//Parts of the code is taken from http://stackoverflow.com/questions/819166/what-is-keyword-density-and-how-to-create-a-script-in-php, authored by Tom
$words = str_word_count(strtolower($sentenceforanalysis),1);
$numWords = count($words);
//### array_count_values() returns an array using the values of the input array as keys and their frequency in input as values.
$word_count = (array_count_values($words));
arsort($word_count);
include '/home/www/php-developer.org/backlinkcount/stopwordslist.php';
$stopwordarray= array();
foreach ($word_count as $key=>$val) {
if ((in_array($key,$stopwords)) || (!(ctype_alpha($key))) || (strlen($key) < 3 )) {
//it is a stop word, assign to array OR not consist entirely of alphabets OR less than 3 letters
$stopwordarray[] = $key;
}
}
//count the stop words detected
$stopwordcount = sizeof($stopwordarray);
//number of words without stop words
$adjustednumWords = $numWords - $stopwordcount;
foreach ($word_count as $key=>$val) {
if ((!(in_array($key,$stopwords))) && (ctype_alpha($key)) && (strlen($key) > 2)) {
		//it is NOT a STOP word; display the word back to the user
    echo "<b>$key = $val</b>. Percent occurrence: ".number_format(($val/$adjustednumWords)*100)."%<br/>\n";
	}
}
}
//Show error in case the form is not posted.
elseif ($_POST[ref] == "linkpopularity") {
echo '<font color="red">This form is not posted.</font>';
}
echo '</font>';
?>
</font>
</body>
</html>