<?php

//Start PHP session

session_start(); 
$key= 'This is your key';

//Add the key to session variable

$_SESSION['key'] = md5($key);

//Pre-defined validation variables

$emailvalidation=TRUE;
$namevalidation=TRUE;
$audiotypevalidation=TRUE;
$captchavalidation=TRUE;

//Check if the form is submitted

if (isset($_POST["formchecker"]) && $_POST["formchecker"] == "submittedform") {

//Form is submitted; start validation of submitted info
//Require email validator: RFC Compliant email validator: //http://www.dominicsayers.com/isemail/results.php

require_once 'is_email.php';

//Define the sanitizing function, ensure that inputs are clean and secure.

function sanitize($data){

//remove spaces from the input

$data=trim($data);

//convert special characters to html entities
//most hacking inputs in XSS are HTML in nature, so converting them to special //characters so that they are not harmful

$data=htmlspecialchars($data);
return $data;
}

//Now to use the sanitizing function, simple use it to sanitize the POST.
//Received posted values from form.

$name=sanitize($_POST["name"]);
$email=sanitize($_POST["email"]);
$audiotype= sanitize($_POST["audiotype"]);

//Validate email

if (!(is_email($email))) {

//Email invalid, return false

$emailvalidation=FALSE;
} else {
$emailvalidation=TRUE;
}

//Validate name

if (empty($name)) {

//Name is empty, return false

$namevalidation=FALSE;
} else {
$namevalidation=TRUE;	
}

//Validate audiotype

if ((empty($audiotype)) || ($audiotype!="wav" && $audiotype!="mp3")) {

//Not a valid audiotype

$audiotypevalidation=FALSE;
} else {
$audiotypevalidation=TRUE;	
}

//Validate recaptcha

require_once('recaptchalib.php');
$privatekey = "Your_recaptcha_private_key_here";
$resp = recaptcha_check_answer ($privatekey,
 $_SERVER["REMOTE_ADDR"], POST["recaptcha_challenge_field"], $_POST["recaptcha_response_field"]);

if (!$resp->is_valid) {

//captcha validation fails

$captchavalidation=FALSE;
} else {
$captchavalidation=TRUE;	
}
if (($emailvalidation==TRUE) && ($namevalidation==TRUE) && ($audiotypevalidation==TRUE) && ($captchavalidation==TRUE)) {

//All validation succeeded, redirect user to confirmation page and start downloading

$redirect = "http://www.example.org/phpdownloadsystem/confirmationpage.php";

//Assigned variables to session

$_SESSION['name'] = $name;
$_SESSION['email'] = $email;
$_SESSION['audiotype'] = $audiotype;

//redirect to confirmation page for downloading

header(sprintf("Location: %s", $redirect));	
exit;
}
}
?>
<!DOCTYPE HTML>
<html>
<head>
<title>PHP Download System Demo</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<style type="text/css">
.invalid {
border: 1px solid #000000;
background: #FF00FF;
}
</style>
</head>
<body >
<h2>PHP Download Script Demo</h2>
<br />
Please enter your name and email address to download the music. Select either WAV or MP3 version.
<br /><br />
<form action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>" method="post">
<input type="hidden" name="formchecker" value="submittedform">
Name:  <input type="text" class="<?php if ($namevalidation==FALSE) echo "invalid"; ?>" id="name" name="name"><?php if ($namevalidation==FALSE) echo '<font color="red">Please enter valid name</font>'; ?><br /><br />
Email: <input name="email" type="text" class="<?php if ($emailvalidation==FALSE) echo "invalid"; ?>" id="email" ><?php if ($emailvalidation==FALSE) echo '<font color="red">Please enter valid email</font>'; ?><br /><br />
Audio file type:<br /><br />
<select class="<?php if ($audiotypevalidation==FALSE) echo "invalid"; ?>" name="audiotype">
<option value=""></option>
<option value="wav">WAV Audio File</option>
<option value="mp3">MP3 Audio File</option>
</select><?php if ($audiotypevalidation==FALSE) echo '<font color="red">Please enter valid audiotype</font>'; ?>
<br /><br />
Type the captcha below:
<br /> <br />
<?php
require_once('recaptchalib.php');
$publickey = "Your_recaptcha_public_key";
echo recaptcha_get_html($publickey);
?>
<?php if ($captchavalidation==FALSE) echo '<font color="red">Please enter correct captcha</font>'; ?>
<br /><br />
<input type="submit" value="Download">                   
</form>
</body>
</html>