<?php
//Gzip compression, you can delete, its optional.
ob_start("ob_gzhandler");
?>
<!--//---------------------------------------------------------------------------------------------------------------------+ |
//  Count Unique Back links using Yahoo API web form written by: Codex-m                                                     |
//	http://www.php-developer.org                                                                                             |
//  License: Open source, Freel free to link TO http://www.php-developer.org to show support, thanks                         |
//--------------------------------------------------------------------------------------------------------------------------->
<html>
<head>
<title>Check your Link Popularity | Free Backlink Check Count Tool</title>
<font face="Courier" size="2">
<h3>This tool will check the number of back links/inbound links coming from unique domains.</h3>
This is your domain "link popularity". Please fill in required data and click "Submit" button.<br />
<br />
<form NAME="linkpopularity" ACTION="<? echo $PHP_SELF; ?>" method="POST">
Enter root domain URL ( for example: <a rel="nofollow" href="http://www.php-developer.org"><b>http://www.php-developer.org</b></a>). URL <b>should</b> start <i>http://</i> and <b>DO NOT include trailing slash at the end.</b><br />
<br />
<input style="background-color: #FFFFC0" type="text" name="domainurl" id="domainurl" size="50">
<br /><br />
Select whether to get unique backlinks to the entire domain or only to the homepage URL<br />
<input type="radio" name="options1" id="options1" value="1" > Entire Site
<br />
<input type="radio" name="options2" id="options2" value="2" > Only to the homepage URL
<br />
<INPUT TYPE="HIDDEN" NAME="ref" VALUE="linkpopularity">
<br /><br />
Type the captcha below:
<br /> <br />
<?php
require_once('recaptchalib.php');
$publickey = "****YOUR OWN RECAPTCHA PUBLIC KEY HERE****";
echo recaptcha_get_html($publickey);
?>
<input type="submit" value="Submit">
</form>
This tool is developed by Codex-m at <a href="http://www.php-developer.org/">www.php-developer.org</a>.<br /><br />
<!-- Input form end -->
<?php
//First, check if the web form has been submitted by checking the value of $_POST[ref]
if($_POST[ref] == "linkpopularity") {
//If the form has been submitted, check if the recaptcha entered by the client is correct.
require_once('recaptchalib.php');
$errors=array();
$privatekey = "****YOUR OWN RECAPTCHA PRIVATE KEY HERE****";
$resp = recaptcha_check_answer ($privatekey,
                                $_SERVER["REMOTE_ADDR"],
                                $_POST["recaptcha_challenge_field"],
                                $_POST["recaptcha_response_field"]);

if (!$resp->is_valid) {
//Display error back to the client is the recaptcha entered is incorrect.
  die('<font color="red">ERROR: The recaptcha code was not entered correctly or expired. If you think it expired or correctly entered; click Recaptcha refresh button to get a new challenge and press submit again.</font>');
}
///////////////////////////////////////////////////////////////////
//extract form inputs and remove spaces//
///////////////////////////////////////////////////////////////////
$domainurl =trim($_POST['domainurl']);
$options1 =trim($_POST['options1']);
$options2 =trim($_POST['options2']);
//////////////////////////////////////////
//Validate userinput domain URL///////////
/////////////////////////////////////////
if (empty($domainurl)) {
//name field is blank
echo 'ERROR: The homepage URL field is empty.';
die ();
}
else {
//it is not empty so validate the user input
$httpprotocol= substr($domainurl, 0, 7);
$httpprotocolwrong=substr($domainurl, 0, 8);
$httpsprotocol =substr($domainurl, 0, 8);
$httpsprotocolwrong= substr($domainurl, 0, 9);
$trailingslash = substr($domainurl, -1);
$firstdot= strpos($domainurl, '.');
$offset=$firstdot + 1;
$seconddot= strpos($domainurl,'.',$offset);
//echo 'first:'.$firstdot;
//echo '<br />';
//echo 'second:'.$seconddot;
//die ();
if (!(($httpprotocol=='http://') || ($httpsprotocol=='https://'))) {
echo 'ERROR: Root domain URL protocol should either only be http:// or https://';
die ();
}
if (($httpprotocolwrong=='http:///') || ($httpsprotocolwrong=='https:///')) {
echo 'ERROR: Root domain URL protocol should either only be http:// or https://';
die ();
}
if ($trailingslash=='/') {
echo 'ERROR: Do not include trailing slash "/" at the end of the URL';
die ();
}
if (($firstdot=='') && ($seconddot=='')) {
echo 'ERROR: Malformed domain root URL';
die ();
}
}
/////////////////////
//Validate options///
/////////////////////
if ($options1==1) {
$options=1;
}
elseif ($options2==2) {
$options='';
}
else {
echo 'ERROR: The options field is empty.';
die ();
}
//Step 1. Report possible errors for debugging
error_reporting(E_ALL);
//Step 2. Declare the request variable
$request =  'http://search.yahooapis.com/SiteExplorerService/V1/inlinkData?appid=****YOUR OWN YAHOO API KEY HERE****&query='.$domainurl.'&results=100&output=php&omit_inlinks=domain&entire_site='.$options;

//Step 3. Read the responses from Yahoo inbound links API and put into a string.
$response = file_get_contents($request);

//Step 4
if ($response === false) {
	die('The request fails.');
}
//Step 5. Convert to unserialized
//create array to store unique domains
$unserialized = unserialize($response);
$display= $unserialized['ResultSet'];
$display1=$display['Result'];
$totalbacklinksnotunique=$display['totalResultsAvailable'];
$domainarray = array();
$x=0;
$count= sizeof($display1);
while ($x < $count) {
$myurl= $display1[$x]['Url'];
//determine the backlink protocol
$httpprotocolcheck =substr($myurl, 0, 7);
$httpsprotocolcheck =substr($myurl, 0, 8);
if ($httpprotocolcheck=="http://") {
//http version
$backlinkprotocol= "http://";
}
if ($httpsprotocolcheck=="https://") {
//https version
$backlinkprotocol= "https://";
}
//assign offset for each protocol
if ($backlinkprotocol=="http://") {
$offsetcount= 7;
}
if ($backlinkprotocol=="https://") {
$offsetcount= 8;
}
//determine 1st occurrence of trailing slash after the protocol
$positiontrailingslash = strpos($myurl, '/', $offsetcount);
$actualposition = $positiontrailingslash - $offsetcount;
//extract domain portion for test of non-www version
$domainportion = substr($myurl, $offsetcount, $actualposition);
//count the number of dots, if only one dot found it is non-www version
$dotcount= substr_count($domainportion, '.');
if ($dotcount==1) {
$domain = $domainportion;
}
if (($dotcount==2) || ($dotcount==3)) {
//this is NOT a non-www version
//find position of 1st dot
$firstdotposition = strpos($myurl, '.');
$firstdotrealoffset= $firstdotposition +1;
//find position of 2nd dot
$seconddotposition = strpos($myurl, '.', $firstdotrealoffset);
$differenceofdots= $seconddotposition - $firstdotposition -1;
 if ($differenceofdots=="2") {
 $domain = $domainportion;
 }
 else {
 $firstdotoffset = $firstdotposition + 1;
 $trailingoffset = $positiontrailingslash - $firstdotposition -1;
 $domain = substr($myurl,$firstdotoffset, $trailingoffset);
 }
}
if ($dotcount==3) {
$firstdotoffset = $firstdotposition + 1;
$trailingoffset = $positiontrailingslash - $firstdotposition -1;
$domain = substr($myurl,$firstdotoffset, $trailingoffset);
}
//echo $domain;
//echo '<br />';
$domainarray[]=$domain;
$x++;
}
//display the unique domains stored in the array
$uniquedomains=array_unique($domainarray);
echo '-----------------------------------------';
echo '<br />';
echo '|THIS IS YOUR LINK POPULARITY STATISTICS:|';
echo '<br />';
echo '-----------------------------------------';
echo '<br />';
////////////////////////////////////////////////
//Estimate total backlinks from unique domains//
////////////////////////////////////////////////
$uniqueinsample = sizeof($uniquedomains);
$uniquebacklinkstotal= ($uniqueinsample/$count)*($totalbacklinksnotunique);
if ($options==1) {
$conditions='ENTIRE SITE';
}
if ($options=='') {
$conditions='THAT SPECIFIC URL ONLY';
}
echo "<b>ESTIMATED TOTAL BACKLINKS FROM UNIQUE DOMAINS POINTING TO $conditions:&nbsp;".round($uniquebacklinkstotal).'</b>';
echo '<br /><br />';
echo "These are the unique domains of the total $totalbacklinksnotunique backlinks pointing to $conditions.";
echo '<br />';
echo "In a sample gathered, you have $uniqueinsample backlinks from unique domains OUT of $count SAMPLES GATHERED";
echo '<br />';
echo 'Below are the sample unique backlinking domains:(100 domains maximum)';
echo '<br /><br />';
while (list($key, $value) = each($uniquedomains)) {
echo $value;
echo '<br />';
}
echo '<br />';
echo 'Note: The above domains might belong to the same Class C IP address.';
echo '<br />';
echo '<br />';
echo '</font>';
}
//Show error in case the form is not posted.
elseif ($_POST[ref] == "linkpopularity") {
echo '<font color="red">This form is not posted.</font>';
}
?>
</font>
</body>
</html>